import pandas as pd
import numpy as np

df = pd.read_csv('norm_df.csv')
bool_columns = df.select_dtypes(include='bool').columns
for col in bool_columns:
    df[col] = df[col].astype(int)
for column in df.columns:
    numpy_array = df[column].to_numpy()
print(df)


num_rows = len(df)
chunk_size = num_rows // 5

for i in range(5):
    start_idx = i * chunk_size
    end_idx = start_idx + chunk_size
    chunk = df.iloc[start_idx:end_idx]
    selected_chunk = chunk.head(2000)
    filename = f'{2014 + i}_clean.csv'
    selected_chunk.to_csv(filename, index=False)